<?php

/**
 * Class providing whois server informations.
 */
class WP24_Domain_Check_Whoisservers {

	/**
	 * @var array Whois server host and free status string.
	 */
	private static $whoisservers = array(
		'aarp' => array('host' => 'whois.nic.aarp', 'free' => 'no match'),
		'abarth' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'abbott' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'abbvie' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'abc' => array('host' => 'whois.nic.abc', 'free' => 'no match'),
		'abogado' => array('host' => 'whois.nic.abogado', 'free' => 'this domain name has not been registered'),
		'abudhabi' => array('host' => 'whois.nic.abudhabi', 'free' => 'no data found'),
		'ac' => array('host' => 'whois.nic.ac', 'free' => 'not found'),
		'co.ac' => array('host' => 'whois.nic.ac', 'free' => 'not found'),
		'gv.ac' => array('host' => 'whois.nic.ac', 'free' => 'not found'),
		'or.ac' => array('host' => 'whois.nic.ac', 'free' => 'not found'),
		'academy' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'accountant' => array('host' => 'whois.nic.accountant', 'free' => 'no data found'),
		'accountants' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'aco' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'actor' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'ad' => array('host' => 'whois.ripe.net', 'free' => 'no entries found'),
		'ads' => array('host' => 'whois.nic.google', 'free' => 'domain not found'),
		'adult' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ae' => array('host' => 'whois-check.aeda.net.ae', 'free' => 'available'),
		'aeg' => array('host' => 'whois.nic.aeg', 'free' => 'no match'),
		'aero' => array('host' => 'whois.aero', 'free' => 'not found'),
		'af' => array('host' => 'whois.nic.af', 'free' => 'no object found'),
		'afl' => array('host' => 'whois.nic.afl', 'free' => 'no data found'),
		'africa' => array('host' => 'whois.nic.africa', 'free' => 'available'),
		'ag' => array('host' => 'whois.nic.ag', 'free' => 'not found'),
		'agakhan' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'agency' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'ai' => array('host' => 'whois.nic.ai', 'free' => 'no object found'),
		'aigo' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'airbus' => array('host' => 'whois.nic.airbus', 'free' => 'no match'),
		'airforce' => array('host' => 'whois.nic.airforce', 'free' => 'domain not found.'),
		'airtel' => array('host' => 'whois.nic.airtel', 'free' => 'no match'),
		'akdn' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'alfaromeo' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'alibaba' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'alipay' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'allstate' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ally' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'alsace' => array('host' => 'whois.nic.alsace', 'free' => 'not found'),
		'alstom' => array('host' => 'whois.nic.alstom', 'free' => 'no match'),
		'am' => array('host' => 'whois.amnic.net', 'free' => 'no match'),
		'americanfamily' => array('host' => 'whois.nic.americanfamily', 'free' => 'no match'),
		'amfam' => array('host' => 'whois.nic.amfam', 'free' => 'no match'),
		'amsterdam' => array('host' => 'whois.nic.amsterdam', 'free' => 'status: free'),
		'android' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'anz' => array('host' => 'whois.nic.anz', 'free' => 'no data found'),
		'aol' => array('host' => 'whois.nic.aol', 'free' => 'no match'),
		'apartments' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'app' => array('host' => 'whois.nic.google', 'free' => 'not found'),
		'apple' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'aquarelle' => array('host' => 'whois.nic.aquarelle', 'free' => 'not found'),
		'ar' => array('host' => 'whois.nic.ar', 'free' => 'no se encuentra registrado'),
		'com.ar' => array('host' => 'whois.nic.ar', 'free' => 'no se encuentra registrado'),
		'archi' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'army' => array('host' => 'whois.nic.army', 'free' => 'domain not found.'),
		'arpa' => array('host' => 'whois.iana.org', 'free' => 'but this server does not have'),
		'e164.arpa' => array('host' => 'whois.ripe.net', 'free' => 'no entries found'),
		'arte' => array('host' => 'whois.nic.arte', 'free' => 'no match'),
		'as' => array('host' => 'whois.nic.as', 'free' => 'not found'),
		'asda' => array('host' => 'whois.nic.asda', 'free' => 'no match'),
		'asia' => array('host' => 'whois.nic.asia', 'free' => 'not found'),
		'associates' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'at' => array('host' => 'whois.nic.at', 'free' => 'nothing found'),
		'ac.at' => array('host' => 'whois.nic.at', 'free' => 'nothing found'),
		'co.at' => array('host' => 'whois.nic.at', 'free' => 'nothing found'),
		'gv.at' => array('host' => 'whois.nic.at', 'free' => 'nothing found'),
		'or.at' => array('host' => 'whois.nic.at', 'free' => 'nothing found'),
		'priv.at' => array('host' => 'whois.nic.priv.at', 'free' => 'no entries found'),
		'attorney' => array('host' => 'whois.nic.attorney', 'free' => 'domain not found.'),
		'au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'asn.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'com.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'csiro.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'edu.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'gov.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'id.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'net.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'org.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'conf.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'info.au' => array('host' => 'whois.audns.net.au', 'free' => 'not found'),
		'auction' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'audi' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'audio' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'auspost' => array('host' => 'whois.nic.auspost', 'free' => 'no data found'),
		'auto' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'autos' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'avianca' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'aw' => array('host' => 'whois.nic.aw', 'free' => 'is free'),
		'ax' => array('host' => 'whois.ax', 'free' => 'domain not found'),
		'baidu' => array('host' => 'whois.gtld.knet.cn', 'free' => 'the queried object does not exist'),
		'band' => array('host' => 'whois.nic.band', 'free' => 'domain not found.'),
		'bank' => array('host' => 'whois.nic.bank', 'free' => 'no match'),
		'barcelona' => array('host' => 'whois.nic.barcelona', 'free' => 'no match'),
		'barclaycard' => array('host' => 'whois.nic.barclaycard', 'free' => 'no data found'),
		'barclays' => array('host' => 'whois.nic.barclays', 'free' => 'no data found'),
		'barefoot' => array('host' => 'whois.nic.barefoot', 'free' => 'no match'),
		'bargains' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'bauhaus' => array('host' => 'whois.nic.bauhaus', 'free' => 'no match'),
		'bayern' => array('host' => 'whois.nic.bayern', 'free' => 'this domain name has not been registered.'),
		'bbc' => array('host' => 'whois.nic.bbc', 'free' => 'this domain name has not been registered'),
		'bbt' => array('host' => 'whois.nic.bbt', 'free' => 'no match'),
		'bbva' => array('host' => 'whois.nic.bbva', 'free' => 'no match'),
		'bcg' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'bcn' => array('host' => 'whois.nic.bcn', 'free' => 'no match'),
		'be' => array('host' => 'whois.dns.be', 'free' => 'status:\s+available'),
		'beats' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'beauty' => array('host' => 'whois.nic.beauty', 'free' => 'no match'),
		'beer' => array('host' => 'whois.nic.beer', 'free' => 'this domain name has not been registered'),
		'bentley' => array('host' => 'whois.nic.bentley', 'free' => 'this domain name has not been registered'),
		'berlin' => array('host' => 'whois.nic.berlin', 'free' => 'object does not exist'),
		'bestbuy' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'bet' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'bg' => array('host' => 'whois.register.bg', 'free' => 'registration status: available'),
		'bi' => array('host' => 'whois1.nic.bi', 'free' => 'domain status: no object found'),
		'bible' => array('host' => 'whois.nic.bible', 'free' => 'no data found'),
		'bid' => array('host' => 'whois.nic.bid', 'free' => 'no data found'),
		'bike' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'bingo' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'bio' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'biz' => array('host' => 'whois.biz', 'free' => 'no data found'),
		'bj' => array('host' => 'whois.nic.bj', 'free' => 'no object found'),
		'black' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'blackfriday' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'blockbuster' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'blue' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'bm' => array('host' => 'whois.bermudanic.bm', 'free' => 'no match'),
		'com.bm' => array('host' => 'whois.bermudanic.bm', 'free' => 'no match'),
		'net.bm' => array('host' => 'whois.bermudanic.bm', 'free' => 'no match'),
		'org.bm' => array('host' => 'whois.bermudanic.bm', 'free' => 'no match'),
		'bms' => array('host' => 'whois.nic.bms', 'free' => 'no match'),
		'bn' => array('host' => 'whois.bnnic.bn', 'free' => 'not found'),
		'bnl' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'bnpparibas' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'boats' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'boehringer' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'bofa' => array('host' => 'whois.nic.bofa', 'free' => 'no match'),
		'bom' => array('host' => 'whois.gtlds.nic.br', 'free' => 'object does not exist'),
		'boo' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'book' => array('host' => 'whois.nic.book', 'free' => 'this domain name has not been registered'),
		'bosch' => array('host' => 'whois.nic.bosch', 'free' => 'no match'),
		'bostik' => array('host' => 'whois.nic.bostik', 'free' => 'not found'),
		'boutique' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'boston' => array('host' => 'whois.nic.boston', 'free' => 'this domain name has not been registered'),
		'br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'app.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'art.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'com.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'dev.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'eco.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'emp.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'log.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'net.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ong.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'seg.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'tec.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'edu.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'blog.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'flog.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'nom.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'vlog.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'wiki.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'adm.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'adv.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'arq.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ato.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'bib.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'bio.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'bmd.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'cim.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'cng.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'cnt.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'coz.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'des.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'det.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ecn.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'enf.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'eng.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'eti.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'fnd.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'fot.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'fst.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'geo.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ggf.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'jor.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'lel.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'mat.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'med.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'mus.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'not.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ntr.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'odo.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ppg.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'pro.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'psc.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'qsl.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'rep.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'slg.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'taxi.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'teo.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'trd.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'vet.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'zlg.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'9guacu.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'abc.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'aju.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'anani.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'aparecida.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'barueri.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'belem.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'bhz.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'boavista.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'bsb.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'campinagrande.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'campinas.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'caxias.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'contagem.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'cuiaba.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'curitiba.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'feira.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'floripa.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'fortal.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'foz.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'goiania.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'gru.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'jab.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'jampa.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'jdf.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'joinville.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'londrina.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'macapa.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'maceio.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'manaus.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'maringa.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'morena.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'natal.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'niteroi.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'osasco.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'palmas.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'poa.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'pvh.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'recife.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ribeirao.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'rio.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'riobranco.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'riopreto.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'salvador.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'sampa.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'santamaria.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'santoandre.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'saobernardo.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'saogonca.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'sjc.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'slz.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'sorocaba.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'the.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'udi.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'vix.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'agr.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'esp.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'etc.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'far.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'imb.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'ind.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'inf.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'radio.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'rec.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'srv.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'tmp.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'tur.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'tv.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'am.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'coop.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'fm.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'g12.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'gov.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'mil.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'org.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'psi.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'b.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'def.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'jus.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'leg.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'mp.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'tc.br' => array('host' => 'whois.nic.br', 'free' => 'no match for'),
		'bradesco' => array('host' => 'whois.nic.bradesco', 'free' => 'this domain name has not been registered'),
		'bridgestone' => array('host' => 'whois.nic.bridgestone', 'free' => 'not found'),
		'broadway' => array('host' => 'whois.nic.broadway', 'free' => 'this domain name has not been registered'),
		'broker' => array('host' => 'whois.nic.broker', 'free' => 'no match'),
		'brother' => array('host' => 'whois.nic.brother', 'free' => 'not found'),
		'brussels' => array('host' => 'whois.nic.brussels', 'free' => 'domain not found.'),
		'budapest' => array('host' => 'whois.nic.budapest', 'free' => 'this domain name has not been registered.'),
		'bugatti' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'build' => array('host' => 'whois.nic.build', 'free' => 'no data found'),
		'builders' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'business' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'buy' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'buzz' => array('host' => 'whois.nic.buzz', 'free' => 'no data found'),
		'bw' => array('host' => 'whois.nic.net.bw', 'free' => 'no object found'),
		'by' => array('host' => 'whois.cctld.by', 'free' => 'object does not exist'),
		'bz' => array('host' => 'whois.afilias-grs.info', 'free' => 'not found'),
		'za.bz' => array('host' => 'whois.afilias-grs.info', 'free' => 'not found'),
		'bzh' => array('host' => 'whois.nic.bzh', 'free' => 'not found'),
		'ca' => array('host' => 'whois.cira.ca', 'free' => 'not found'),
		'co.ca' => array('host' => 'whois.co.ca', 'free' => 'is available.'),
		'cab' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'cafe' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'cal' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'camera' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'camp' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'cancerresearch' => array('host' => 'whois.nic.cancerresearch', 'free' => 'no data found'),
		'canon' => array('host' => 'whois.nic.canon', 'free' => 'not found'),
		'capetown' => array('host' => 'whois.nic.capetown', 'free' => 'available'),
		'capital' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'capitalone' => array('host' => 'whois.nic.capitalone', 'free' => 'no match'),
		'car' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'cards' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'care' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'career' => array('host' => 'whois.nic.career', 'free' => 'no match for'),
		'careers' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'cars' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'casa' => array('host' => 'whois.nic.casa', 'free' => 'this domain name has not been registered'),
		'case' => array('host' => 'whois.nic.case', 'free' => 'domain not found'),
		'caseih' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'cash' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'casino' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'cat' => array('host' => 'whois.nic.cat', 'free' => 'no matching objects found'),
		'catering' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'cba' => array('host' => 'whois.nic.cba', 'free' => 'no data found'),
		'cbs' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'cc' => array('host' => 'ccwhois.verisign-grs.com', 'free' => 'no match for'),
		'cd' => array('host' => 'whois.nic.cd', 'free' => 'no object found'),
		'ceb' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'center' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'cern' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'cf' => array('host' => 'whois.freenom.com', 'free' => 'domain name not known'),
		'cfa' => array('host' => 'whois.nic.cfa', 'free' => 'no match'),
		'cfd' => array('host' => 'whois.nic.cfd', 'free' => 'domain not found'),
		'ch' => array('host' => 'whois.nic.ch', 'rdap' => 'rdap.nic.ch', 'free' => 'domain name can be registered'),
		'chanel' => array('host' => 'whois.nic.chanel', 'free' => 'no match'),
		'channel' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'charity' => array('host' => 'whois.nic.charity', 'free' => 'domain not found.'),
		'chat' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'cheap' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'chintai' => array('host' => 'whois.nic.chintai', 'free' => 'no data found'),
		'christmas' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'chrome' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'chrysler' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'church' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'ci' => array('host' => 'whois.nic.ci', 'free' => 'no object found'),
		'cipriani' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'city' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'cityeats' => array('host' => 'whois.nic.cityeats', 'free' => 'no match'),
		'cl' => array('host' => 'whois.nic.cl', 'free' => 'no entries found'),
		'claims' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'cleaning' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'click' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'clinic' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'clinique' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'clothing' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'cloud' => array('host' => 'whois.nic.cloud', 'free' => 'no data found'),
		'club' => array('host' => 'whois.nic.club', 'free' => 'no data found'),
		'clubmed' => array('host' => 'whois.nic.clubmed', 'free' => 'no match'),
		'cm' => array('host' => 'whois.netcom.cm', 'free' => 'status: not registered'),
		'cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no match'),
		'ac.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'ah.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'bj.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'com.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'cq.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'gd.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'gov.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'gs.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'gx.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'gz.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'hb.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'he.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'hi.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'hk.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'hl.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'hn.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'jl.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'js.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'ln.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'mo.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'net.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'nm.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'nx.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'org.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'qh.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'sc.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'sh.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'sn.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'tj.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'tw.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'xj.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'xz.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'yn.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'zj.cn' => array('host' => 'whois.cnnic.cn', 'free' => 'no matching record'),
		'co' => array('host' => 'whois.nic.co', 'free' => 'no data found'),
		'com.co' => array('host' => 'whois.nic.co', 'free' => 'no data found'),
		'net.co' => array('host' => 'whois.nic.co', 'free' => 'no data found'),
		'nom.co' => array('host' => 'whois.nic.co', 'free' => 'no data found'),
		'coach' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'codes' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'coffee' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'cologne' => array('host' => 'whois.nic.koeln', 'free' => 'no information was found'),
		'com' => array('host' => 'whois.crsnic.net', 'free' => 'no match for'),
		'ae.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'africa.com' => array('host' => 'srs-whois.dns.net.za', 'free' => 'no information was found'),
		'ar.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'br.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'cn.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'co.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'de.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'eu.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'gb.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'gr.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'hu.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'jpn.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'kr.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'lovesnaija.com' => array('host' => 'srs-whois.dns.net.za', 'free' => 'no information was found'),
		'no.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'qc.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'ru.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'sa.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'se.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'uk.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'us.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'uy.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'web.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'za.com' => array('host' => 'whois.verisign-grs.com', 'free' => 'no match for'),
		'comcast' => array('host' => 'whois.nic.comcast', 'free' => 'this domain name has not been registered.'),
		'commbank' => array('host' => 'whois.nic.commbank', 'free' => 'no data found'),
		'community' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'company' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'compare' => array('host' => 'whois.nic.compare', 'free' => 'no data found'),
		'computer' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'comsec' => array('host' => 'whois.nic.comsec', 'free' => 'no match'),
		'condos' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'construction' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'consulting' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'contact' => array('host' => 'whois.nic.contact', 'free' => 'domain not found.'),
		'contractors' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'cooking' => array('host' => 'whois.nic.cooking', 'free' => 'this domain name has not been registered'),
		'cookingchannel' => array('host' => 'whois.nic.cookingchannel', 'free' => 'no match'),
		'cool' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'coop' => array('host' => 'whois.nic.coop', 'free' => 'is available for registration'),
		'corsica' => array('host' => 'whois.nic.corsica', 'free' => 'not found'),
		'country' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'coupon' => array('host' => 'whois.nic.coupon', 'free' => 'no data found'),
		'coupons' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'courses' => array('host' => 'whois.nic.courses', 'free' => 'no data found'),
		'cpa' => array('host' => 'whois.nic.cpa', 'free' => 'no data found'),
		'cr' => array('host' => 'whois.nic.cr', 'free' => 'no entries found'),
		'credit' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'creditcard' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'creditunion' => array('host' => 'whois.nic.creditunion', 'free' => 'is available for registration'),
		'cricket' => array('host' => 'whois.nic.cricket', 'free' => 'no data found'),
		'cruises' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'cuisinella' => array('host' => 'whois.nic.cuisinella', 'free' => 'no data found'),
		'cx' => array('host' => 'whois.nic.cx', 'free' => 'no object found'),
		'cymru' => array('host' => 'whois.nic.cymru', 'free' => 'this domain name has not been registered'),
		'cz' => array('host' => 'whois.nic.cz', 'free' => 'no entries found'),
		'dabur' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'dad' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'dance' => array('host' => 'whois.nic.dance', 'free' => 'domain not found.'),
		'data' => array('host' => 'whois.nic.data', 'free' => 'not found'),
		'date' => array('host' => 'whois.nic.date', 'free' => 'no data found'),
		'dating' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'datsun' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'day' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'dclk' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'dds' => array('host' => 'whois.nic.dds', 'free' => 'this domain name has not been registered'),
		'de' => array('host' => 'whois.denic.de', 'free' => 'status: free'),
		'deal' => array('host' => 'whois.nic.deal', 'free' => 'this domain name has not been registered'),
		'dealer' => array('host' => 'whois.nic.dealer', 'free' => 'is available for registration'),
		'deals' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'degree' => array('host' => 'whois.nic.degree', 'free' => 'domain not found.'),
		'delivery' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'delta' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'democrat' => array('host' => 'whois.nic.democrat', 'free' => 'domain not found.'),
		'dental' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'dentist' => array('host' => 'whois.nic.dentist', 'free' => 'domain not found.'),
		'dev' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'diamonds' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'diet' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'digital' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'direct' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'directory' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'discount' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'dish' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'diy' => array('host' => 'whois.nic.diy', 'free' => 'is available for registration'),
		'dk' => array('host' => 'whois.dk-hostmaster.dk', 'free' => 'no entries found'),
		'dm' => array('host' => 'whois.nic.dm', 'free' => 'not found'),
		'do' => array('host' => 'whois.nic.do', 'free' => 'no object found'),
		'docs' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'doctor' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'dodge' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'dog' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'domains' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'dot' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'download' => array('host' => 'whois.nic.download', 'free' => 'no data found'),
		'drive' => array('host' => 'whois.nic.google', 'free' => 'not found'),
		'dtv' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'dubai' => array('host' => 'whois.nic.dubai', 'free' => 'no match'),
		'dunlop' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'durban' => array('host' => 'whois.nic.durban', 'free' => 'available'),
		'dvr' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'dz' => array('host' => 'whois.nic.dz', 'free' => 'no object found!'),
		'earth' => array('host' => 'whois.nic.earth', 'free' => 'no data found'),
		'eat' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'eco' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'edeka' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'edu' => array('host' => 'whois.educause.edu', 'free' => 'no match'),
		'education' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'ee' => array('host' => 'whois.eenet.ee', 'free' => 'not found'),
		'email' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'emerck' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'energy' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'engineer' => array('host' => 'whois.nic.engineer', 'free' => 'domain not found.'),
		'engineering' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'enterprises' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'equipment' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'ericsson' => array('host' => 'whois.nic.ericsson', 'free' => 'no match'),
		'erni' => array('host' => 'whois.nic.erni', 'free' => 'no match'),
		'esq' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'estate' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'esurance' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'et' => array('host' => 'whois.ethiotelecom.et', 'free' => 'the queried object does not exist'),
		'eu' => array('host' => 'whois.eu', 'free' => 'status: available'),
		'eurovision' => array('host' => 'whois.nic.eurovision', 'free' => 'no match'),
		'eus' => array('host' => 'whois.nic.eus', 'free' => 'no matching objects found'),
		'events' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'exchange' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'expert' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'exposed' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'express' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'extraspace' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'fage' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'fail' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'fairwinds' => array('host' => 'whois.nic.fairwinds', 'free' => 'no match'),
		'faith' => array('host' => 'whois.nic.faith', 'free' => 'no data found'),
		'family' => array('host' => 'whois.nic.family', 'free' => 'domain not found.'),
		'fan' => array('host' => 'whois.nic.fan', 'free' => 'not found'),
		'farm' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'fashion' => array('host' => 'whois.nic.fashion', 'free' => 'this domain name has not been registered'),
		'fedex' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ferrari' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'fi' => array('host' => 'whois.fi', 'free' => 'not found'),
		'fiat' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'fidelity' => array('host' => 'whois.nic.fidelity', 'free' => 'no match'),
		'fido' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'film' => array('host' => 'whois.nic.film', 'free' => 'no match'),
		'final' => array('host' => 'whois.gtlds.nic.br', 'free' => 'object does not exist'),
		'finance' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'financial' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'firestone' => array('host' => 'whois.nic.firestone', 'free' => 'not found'),
		'firmdale' => array('host' => 'whois.nic.firmdale', 'free' => 'not found'),
		'fish' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'fishing' => array('host' => 'whois.nic.fishing', 'free' => 'this domain name has not been registered'),
		'fit' => array('host' => 'whois.nic.fit', 'free' => 'this domain name has not been registered'),
		'fitness' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'fj' => array('host' => 'whois.usp.ac.fj', 'free' => 'not found'),
		'flights' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'florist' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'flowers' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'fly' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'foo' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'food' => array('host' => 'whois.nic.food', 'free' => 'is available for registration'),
		'foodnetwork' => array('host' => 'whois.nic.foodnetwork', 'free' => 'no match'),
		'football' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'forex' => array('host' => 'whois.nic.forex', 'free' => 'no match'),
		'forsale' => array('host' => 'whois.nic.forsale', 'free' => 'domain not found.'),
		'foundation' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'fr' => array('host' => 'whois.nic.fr', 'free' => 'not found'),
		'free' => array('host' => 'whois.nic.free', 'free' => 'this domain name has not been registered'),
		'aeroport.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'asso.fr' => array('host' => 'whois.nic.fr', 'free' => 'no entries found'),
		'avocat.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'chambagri.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'chirurgiens-dentistes.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'com.fr' => array('host' => 'whois.nic.fr', 'free' => 'no entries found'),
		'experts-comptables.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'geometre-expert.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'medecin.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'notaires.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'pharmacien.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'port.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'presse.fr' => array('host' => 'whois.nic.fr', 'free' => 'no entries found'),
		'tm.fr' => array('host' => 'whois.nic.fr', 'free' => 'no entries found'),
		'veterinaire.fr' => array('host' => 'whois.smallregistry.net', 'free' => 'object not found'),
		'frogans' => array('host' => 'whois.nic.frogans', 'free' => 'not found'),
		'frontdoor' => array('host' => 'whois.nic.frontdoor', 'free' => 'no match'),
		'fujitsu' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'fund' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'furniture' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'futbol' => array('host' => 'whois.nic.futbol', 'free' => 'domain not found.'),
		'fyi' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'ga' => array('host' => 'whois.freenom.com', 'free' => 'domain name not known'),
		'gal' => array('host' => 'whois.nic.gal', 'free' => 'no matching objects found'),
		'gallery' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'gallo' => array('host' => 'whois.nic.gallo', 'free' => 'no match'),
		'gallup' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'game' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'games' => array('host' => 'whois.nic.games', 'free' => 'domain not found.'),
		'garden' => array('host' => 'whois.nic.garden', 'free' => 'this domain name has not been registered'),
		'gbiz' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'gdn' => array('host' => 'whois.nic.gdn', 'free' => 'not found'),
		'ge' => array('host' => 'whois.nic.ge', 'free' => 'no match'),
		'com.ge' => array('host' => 'whois.nic.ge', 'free' => 'no match'),
		'edu.ge' => array('host' => 'whois.nic.ge', 'free' => 'no match'),
		'net.ge' => array('host' => 'whois.nic.ge', 'free' => 'no match'),
		'org.ge' => array('host' => 'whois.nic.ge', 'free' => 'no match'),
		'pvt.ge' => array('host' => 'whois.nic.ge', 'free' => 'no match'),
		'gea' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'genting' => array('host' => 'whois.nic.genting', 'free' => 'no match'),
		'george' => array('host' => 'whois.nic.george', 'free' => 'no match'),
		'gf' => array('host' => 'whois.mediaserv.net', 'free' => 'no object found'),
		'gg' => array('host' => 'whois.channelisles.net', 'free' => 'not found'),
		'ggee' => array('host' => 'whois.nic.ggee', 'free' => 'not found'),
		'gi' => array('host' => 'whois.afilias-grs.info', 'free' => 'not found'),
		'gift' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'gifts' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'gives' => array('host' => 'whois.nic.gives', 'free' => 'domain not found.'),
		'giving' => array('host' => 'whois.nic.giving', 'free' => 'no data found'),
		'gl' => array('host' => 'whois.nic.gl', 'free' => 'no object found'),
		'glass' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'gle' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'global' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'globo' => array('host' => 'whois.gtlds.nic.br', 'free' => 'object does not exist'),
		'gmail' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'gmbh' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'gmx' => array('host' => 'whois-fe1.gmx.tango.knipp.de', 'free' => 'no match'),
		'godaddy' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'gold' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'goldpoint' => array('host' => 'whois.nic.goldpoint', 'free' => 'not found'),
		'golf' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'goo' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'goodyear' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'goog' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'google' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'gop' => array('host' => 'whois.nic.gop', 'free' => 'this domain name has not been registered'),
		'gov' => array('host' => 'whois.dotgov.gov', 'free' => 'no match for'),
		'gp' => array('host' => 'whois.nic.gp', 'free' => 'no record found'),
		'com.gp' => array('host' => 'whois.nic.gp', 'free' => 'no record found'),
		'mobi.gp' => array('host' => 'whois.nic.gp', 'free' => 'no record found'),
		'net.gp' => array('host' => 'whois.nic.gp', 'free' => 'no record found'),
		'gq' => array('host' => 'whois.freenom.com', 'free' => 'domain name not known'),
		'graphics' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'gratis' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'green' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'gripe' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'group' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'gs' => array('host' => 'whois.nic.gs', 'free' => 'no object found'),
		'guge' => array('host' => 'whois.nic.google', 'free' => 'not found'),
		'guide' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'guitars' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'guru' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'gy' => array('host' => 'whois.registry.gy', 'free' => 'domain status: no object found'),
		'hamburg' => array('host' => 'whois.nic.hamburg', 'free' => 'object does not exist'),
		'hangout' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'haus' => array('host' => 'whois.nic.haus', 'free' => 'domain not found.'),
		'hdfc' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'hdfcbank' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'health' => array('host' => 'whois.nic.health', 'free' => 'no data found'),
		'healthcare' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'help' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'helsinki' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'here' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'hermes' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'hgtv' => array('host' => 'whois.nic.hgtv', 'free' => 'no match'),
		'hiphop' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'hisamitsu' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'hitachi' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'hiv' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'hk' => array('host' => 'whois.hkirc.hk', 'free' => 'the domain has not been registered'),
		'com.hk' => array('host' => 'whois.hkdnr.net.hk', 'free' => 'the domain has not been registered'),
		'edu.hk' => array('host' => 'whois.hkdnr.net.hk', 'free' => 'the domain has not been registered'),
		'net.hk' => array('host' => 'whois.hkdnr.net.hk', 'free' => 'the domain has not been registered'),
		'org.hk' => array('host' => 'whois.hkdnr.net.hk', 'free' => 'the domain has not been registered'),
		'hkt' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'hn' => array('host' => 'whois.nic.hn', 'free' => 'no object found'),
		'hockey' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'holdings' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'holiday' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'homedepot' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'honda' => array('host' => 'whois.nic.honda', 'free' => 'not found'),
		'hospital' => array('host' => 'whois.nic.hospital', 'free' => 'domain not found.'),
		'horse' => array('host' => 'whois.nic.horse', 'free' => 'this domain name has not been registered'),
		'hosting' => array('host' => 'whois.nic.hosting', 'free' => 'is available for registration'),
		'hot' => array('host' => 'whois.nic.hot', 'free' => 'this domain name has not been registered'),
		'hotels' => array('host' => 'whois.nic.hotels', 'free' => 'no data found'),
		'house' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'how' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'hr' => array('host' => 'whois.dns.hr', 'free' => 'no entries found'),
		'ht' => array('host' => 'whois.nic.ht', 'free' => 'no object found'),
		'hu' => array('host' => 'whois.nic.hu', 'free' => 'no match'),
		'hughes' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'hyundai' => array('host' => 'whois.nic.hyundai', 'free' => 'not found'),
		'ibm' => array('host' => 'whois.nic.ibm', 'free' => 'no data found'),
		'icbc' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ice' => array('host' => 'whois.nic.ice', 'free' => 'no match'),
		'id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'ac.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'biz.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'co.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'desa.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'go.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'mil.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'my.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'net.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'or.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'ponpes.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'sch.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'web.id' => array('host' => 'whois.id', 'free' => 'domain not found'),
		'ie' => array('host' => 'whois.weare.ie', 'free' => 'not found'),
		'ifm' => array('host' => 'whois.nic.ifm', 'free' => 'no match'),
		'ikano' => array('host' => 'whois.ikano.tld-box.at', 'free' => 'object does not exist'),
		'co.il' => array('host' => 'whois.isoc.org.il', 'free' => 'no data was found'),
		'org.il' => array('host' => 'whois.isoc.org.il', 'free' => 'no data was found'),
		'im' => array('host' => 'whois.nic.im', 'free' => 'not found'),
		'imamat' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'immo' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'immobilien' => array('host' => 'whois.nic.immobilien', 'free' => 'domain not found.'),
		'in' => array('host' => 'whois.registry.in', 'free' => 'no data found'),
		'co.in' => array('host' => 'whois.registry.in', 'free' => 'no data found'),
		'firm.in' => array('host' => 'whois.registry.in', 'free' => 'no data found'),
		'gen.in' => array('host' => 'whois.registry.in', 'free' => 'no data found'),
		'ind.in' => array('host' => 'whois.registry.in', 'free' => 'no data found'),
		'net.in' => array('host' => 'whois.registry.in', 'free' => 'no data found'),
		'org.in' => array('host' => 'whois.registry.in', 'free' => 'no data found'),
		'inc' => array('host' => 'whois.nic.inc', 'free' => 'available for registration'),
		'industries' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'infiniti' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'info' => array('host' => 'whois.afilias.info', 'free' => 'not found'),
		'ing' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'institute' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'insurance' => array('host' => 'whois.nic.insurance', 'free' => 'no match'),
		'insure' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'int' => array('host' => 'whois.iana.org', 'free' => 'but this server does not have'),
		'international' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'investments' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'io' => array('host' => 'whois.nic.io', 'free' => 'not found'),
		'ir' => array('host' => 'whois.nic.ir', 'free' => 'no entries found'),
		'irish' => array('host' => 'whois.nic.irish', 'free' => 'domain not found.'),
		'is' => array('host' => 'whois.isnic.is', 'free' => 'no entries found'),
		'ismaili' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ist' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'istanbul' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'it' => array('host' => 'whois.nic.it', 'free' => 'status: available'),
		'itv' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'iveco' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'jaguar' => array('host' => 'whois.nic.jaguar', 'free' => 'no match'),
		'java' => array('host' => 'whois.nic.java', 'free' => 'no match'),
		'jcb' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'jcp' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'je' => array('host' => 'whois.channelisles.net', 'free' => 'not found'),
		'jeep' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'jetzt' => array('host' => 'whois.nic.jetzt', 'free' => 'not found'),
		'jewelry' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'jll' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'jobs' => array('host' => 'whois.nic.jobs', 'free' => 'no match'),
		'joburg' => array('host' => 'whois.nic.joburg', 'free' => 'available'),
		'joy' => array('host' => 'whois.nic.joy', 'free' => 'this domain name has not been registered'),
		'jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'ac.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'ad.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'co.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'ed.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'go.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'gr.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'lg.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'ne.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'or.jp' => array('host' => 'whois.jprs.jp', 'free' => 'no match'),
		'juegos' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'juniper' => array('host' => 'whois.nic.juniper', 'free' => 'no match'),
		'kaufen' => array('host' => 'whois.nic.kaufen', 'free' => 'domain not found.'),
		'kddi' => array('host' => 'whois.nic.kddi', 'free' => 'not found'),
		'ke' => array('host' => 'whois.kenic.or.ke', 'free' => 'no object found'),
		'ac.ke' => array('host' => 'whois.kenic.or.ke', 'free' => 'no object found'),
		'co.ke' => array('host' => 'whois.kenic.or.ke', 'free' => 'no object found'),
		'kerryhotels' => array('host' => 'whois.nic.kerryhotels', 'free' => 'no match'),
		'kerrylogistics' => array('host' => 'whois.nic.kerrylogistics', 'free' => 'no match'),
		'kerryproperties' => array('host' => 'whois.nic.kerryproperties', 'free' => 'no match'),
		'kg' => array('host' => 'whois.kg', 'free' => 'data not found'),
		'com.kg' => array('host' => 'whois.kg', 'free' => 'data not found'),
		'net.kg' => array('host' => 'whois.kg', 'free' => 'data not found'),
		'org.kg' => array('host' => 'whois.kg', 'free' => 'data not found'),
		'kia' => array('host' => 'whois.nic.kia', 'free' => 'not found'),
		'kids' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'kim' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'kitchen' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'kiwi' => array('host' => 'whois.nic.kiwi', 'free' => 'not found'),
		'kn' => array('host' => 'whois.nic.kn', 'free' => 'no object found'),
		'koeln' => array('host' => 'whois.nic.koeln', 'free' => 'no information was found'),
		'komatsu' => array('host' => 'whois.nic.komatsu', 'free' => 'not found'),
		'kosher' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'kr' => array('host' => 'whois.kr', 'free' => 'the requested domain was not found'),
		'ac.kr' => array('host' => 'whois.nic.or.kr', 'free' => 'domain was not found'),
		'co.kr' => array('host' => 'whois.nic.or.kr', 'free' => 'domain was not found'),
		'go.kr' => array('host' => 'whois.nic.or.kr', 'free' => 'domain was not found'),
		'ne.kr' => array('host' => 'whois.nic.or.kr', 'free' => 'domain was not found'),
		'nm.kr' => array('host' => 'whois.nic.or.kr', 'free' => 'domain was not found'),
		'or.kr' => array('host' => 'whois.nic.or.kr', 'free' => 'domain was not found'),
		're.kr' => array('host' => 'whois.nic.or.kr', 'free' => 'domain was not found'),
		'krd' => array('host' => 'whois.nic.krd', 'free' => 'no data found'),
		'kuokgroup' => array('host' => 'whois.nic.kuokgroup', 'free' => 'no match'),
		'ky' => array('host' => 'whois.kyregistry.ky', 'free' => 'is available for registration'),
		'kyoto' => array('host' => 'whois.nic.kyoto', 'free' => 'not found'),
		'kz' => array('host' => 'whois.nic.kz', 'free' => 'nothing found'),
		'la' => array('host' => 'whois.nic.la', 'free' => 'not found'),
		'lacaixa' => array('host' => 'whois.nic.lacaixa', 'free' => 'no match'),
		'lamborghini' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'lamer' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'lancaster' => array('host' => 'whois.nic.lancaster', 'free' => 'not found'),
		'lancia' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'land' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'landrover' => array('host' => 'whois.nic.landrover', 'free' => 'no match'),
		'lasalle' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'latino' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'latrobe' => array('host' => 'whois.nic.latrobe', 'free' => 'no data found'),
		'law' => array('host' => 'whois.nic.law', 'free' => 'this domain name has not been registered'),
		'lawyer' => array('host' => 'whois.nic.lawyer', 'free' => 'domain not found.'),
		'lc' => array('host' => 'whois.afilias-grs.info', 'free' => 'not found'),
		'lds' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'lease' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'leclerc' => array('host' => 'whois.nic.leclerc', 'free' => 'not found'),
		'lefrak' => array('host' => 'whois.nic.lefrak', 'free' => 'no match'),
		'legal' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'lego' => array('host' => 'whois.nic.lego', 'free' => 'no match'),
		'lexus' => array('host' => 'whois.nic.lexus', 'free' => 'not found'),
		'lgbt' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'li' => array('host' => 'whois.nic.li', 'free' => 'not have an entry'),
		'life' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'lifestyle' => array('host' => 'whois.nic.lifestyle', 'free' => 'is available for registration'),
		'lighting' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'like' => array('host' => 'whois.nic.like', 'free' => 'this domain name has not been registered'),
		'limited' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'limo' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'linde' => array('host' => 'whois.nic.linde', 'free' => 'no match'),
		'link' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'lipsy' => array('host' => 'whois.nic.lipsy', 'free' => 'no match'),
		'live' => array('host' => 'whois.nic.live', 'free' => 'domain not found.'),
		'living' => array('host' => 'whois.nic.living', 'free' => 'is available for registration'),
		'llc' => array('host' => 'whois.nic.llc', 'free' => 'not found'),
		'loan' => array('host' => 'whois.nic.loan', 'free' => 'no data found'),
		'loans' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'locker' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'locus' => array('host' => 'whois.nic.locus', 'free' => 'this domain name has not been registered'),
		'lol' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'london' => array('host' => 'whois.nic.london', 'free' => 'this domain name has not been registered'),
		'lotte' => array('host' => 'whois.nic.lotte', 'free' => 'not found'),
		'lotto' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'ls' => array('host' => 'whois.nic.ls', 'free' => 'no entries found'),
		'lt' => array('host' => 'whois.domreg.lt', 'free' => 'status:\s+available'),
		'ltd' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'ltda' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'lu' => array('host' => 'whois.dns.lu', 'free' => '% no such domain'),
		'lundbeck' => array('host' => 'whois.nic.lundbeck', 'free' => 'no match'),
		'luxe' => array('host' => 'whois.nic.luxe', 'free' => 'this domain name has not been registered'),
		'luxury' => array('host' => 'whois.nic.luxury', 'free' => 'no data found'),
		'lv' => array('host' => 'whois.nic.lv', 'free' => 'status: free'),
		'eu.lv' => array('host' => 'whois.biz', 'free' => 'no data found'),
		'ly' => array('host' => 'whois.nic.ly', 'free' => 'not found'),
		'ma' => array('host' => 'whois.iam.net.ma', 'free' => 'no object found'),
		'macys' => array('host' => 'whois.nic.macys', 'free' => 'no match'),
		'madrid' => array('host' => 'whois.madrid.rs.corenic.net', 'free' => 'no match'),
		'maison' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'makeup' => array('host' => 'whois.nic.makeup', 'free' => 'no match'),
		'man' => array('host' => 'whois.nic.man', 'free' => 'no match'),
		'management' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'mango' => array('host' => 'whois.nic.mango', 'free' => 'no matching objects found'),
		'map' => array('host' => 'whois.nic.google', 'free' => 'domain not found'),
		'market' => array('host' => 'whois.nic.market', 'free' => 'domain not found.'),
		'marketing' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'markets' => array('host' => 'whois.nic.markets', 'free' => 'no match'),
		'marriott' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'maserati' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'mba' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'mckinsey' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'md' => array('host' => 'whois.nic.md', 'free' => 'no match for'),
		'me' => array('host' => 'whois.nic.me', 'free' => 'not found'),
		'med' => array('host' => 'whois.nic.med', 'free' => 'no match'),
		'media' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'meet' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'melbourne' => array('host' => 'whois.nic.melbourne', 'free' => 'no data found'),
		'meme' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'memorial' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'men' => array('host' => 'whois.nic.men', 'free' => 'no data found'),
		'menu' => array('host' => 'whois.nic.menu', 'free' => 'no data found'),
		'metlife' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'mg' => array('host' => 'whois.nic.mg', 'free' => 'no object found'),
		'miami' => array('host' => 'whois.nic.miami', 'free' => 'this domain name has not been registered'),
		'mil' => array('host' => 'whois.internic.net', 'free' => 'no match for'),
		'mit' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'mitsubishi' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'mk' => array('host' => 'whois.marnet.mk', 'free' => '% no entries found.'),
		'ml' => array('host' => 'whois.freenom.com', 'free' => 'domain name not known'),
		'mls' => array('host' => 'whois.nic.mls', 'free' => 'not found'),
		'mma' => array('host' => 'whois.nic.mma', 'free' => 'not found'),
		'mn' => array('host' => 'whois.afilias-grs.info', 'free' => 'not found'),
		'mo' => array('host' => 'whois.monic.mo', 'free' => 'no match for'),
		'mobi' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'mobile' => array('host' => 'whois.nic.mobile', 'free' => 'not found'),
		'moda' => array('host' => 'whois.nic.moda', 'free' => 'domain not found.'),
		'moe' => array('host' => 'whois.nic.moe', 'free' => 'no data found'),
		'moi' => array('host' => 'whois.nic.moi', 'free' => 'this domain name has not been registered'),
		'mom' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'monash' => array('host' => 'whois.nic.monash', 'free' => 'no data found'),
		'money' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'mopar' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'mormon' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'mortgage' => array('host' => 'whois.nic.mortgage', 'free' => 'domain not found.'),
		'moscow' => array('host' => 'whois.nic.moscow', 'free' => 'domain not found.'),
		'motorcycles' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'mov' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'movie' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'mq' => array('host' => 'whois.mediaserv.net', 'free' => 'no object found'),
		'mr' => array('host' => 'whois.nic.mr', 'free' => 'no object found'),
		'ms' => array('host' => 'whois.nic.ms', 'free' => 'no object found'),
		'mt' => array('host' => 'whois.nic.org.mt', 'free' => 'domain is not registered'),
		'mtn' => array('host' => 'whois.nic.mtn', 'free' => 'no data found'),
		'mtpc' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'mtr' => array('host' => 'whois.nic.mtr', 'free' => 'the domain has not been registered'),
		'mu' => array('host' => 'whois.nic.mu', 'free' => 'no object found'),
		'museum' => array('host' => 'whois.museum', 'free' => 'object does not exist'),
		'mw' => array('host' => 'whois.nic.mw', 'free' => 'no entries found'),
		'mz' => array('host' => 'whois.nic.mz', 'free' => 'no object found'),
		'na' => array('host' => 'whois.na-nic.com.na', 'free' => 'no object found'),
		'nab' => array('host' => 'whois.nic.nab', 'free' => 'no match'),
		'nagoya' => array('host' => 'whois.gmoregistry.net', 'free' => 'not found'),
		'name' => array('host' => 'whois.nic.name', 'free' => 'no match'),
		'natura' => array('host' => 'whois.gtlds.nic.br', 'free' => 'object does not exist'),
		'navy' => array('host' => 'whois.nic.navy', 'free' => 'domain not found.'),
		'nc' => array('host' => 'whois.nc', 'free' => 'no entries found'),
		'nec' => array('host' => 'whois.nic.nec', 'free' => 'not found'),
		'net' => array('host' => 'whois.crsnic.net', 'free' => 'no match for'),
		'netbank' => array('host' => 'whois.nic.netbank', 'free' => 'no data found'),
		'network' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'new' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'newholland' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'news' => array('host' => 'whois.nic.news', 'free' => 'domain not found.'),
		'next' => array('host' => 'whois.nic.next', 'free' => 'no match'),
		'nextdirect' => array('host' => 'whois.nic.nextdirect', 'free' => 'no match'),
		'nexus' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'nf' => array('host' => 'whois.nic.nf', 'free' => 'no object found'),
		'ng' => array('host' => 'whois.nic.net.ng', 'free' => 'no object found'),
		'ngo' => array('host' => 'whois.publicinterestregistry.net', 'free' => 'not found'),
		'nico' => array('host' => 'whois.nic.nico', 'free' => 'not found'),
		'nikon' => array('host' => 'whois.nic.nikon', 'free' => 'no match'),
		'ninja' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'nissan' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'nissay' => array('host' => 'whois.nic.nissay', 'free' => 'no match'),
		'nl' => array('host' => 'whois.domain-registry.nl', 'free' => 'is free'),
		'no' => array('host' => 'whois.norid.no', 'free' => 'no match'),
		'nokia' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'norton' => array('host' => 'whois.nic.norton', 'free' => 'no match'),
		'now' => array('host' => 'whois.nic.now', 'free' => 'this domain name has not been registered'),
		'nowruz' => array('host' => 'whois.agitsys.net', 'free' => 'no object found'),
		'nowtv' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'nra' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'nrw' => array('host' => 'whois.nic.nrw', 'free' => 'no match'),
		'nu' => array('host' => 'whois.iis.nu', 'free' => 'not found'),
		'nyc' => array('host' => 'whois.nic.nyc', 'free' => 'no data found'),
		'nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'ac.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'co.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'cri.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'geek.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'gen.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'govt.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'iwi.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'health.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'kiwi.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'maori.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'mil.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'net.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'org.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'parliament.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'school.nz' => array('host' => 'whois.irs.net.nz', 'free' => 'not found'),
		'obi' => array('host' => 'whois.nic.obi', 'free' => 'no match'),
		'okinawa' => array('host' => 'whois.nic.okinawa', 'free' => 'domain not found'),
		'olayan' => array('host' => 'whois.nic.olayan', 'free' => 'no data found'),
		'olayangroup' => array('host' => 'whois.nic.olayangroup', 'free' => 'no data found'),
		'ollo' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'om' => array('host' => 'whois.registry.om', 'free' => 'no data found'),
		'omega' => array('host' => 'whois.nic.omega', 'free' => 'no match'),
		'one' => array('host' => 'whois.nic.one', 'free' => 'no data found'),
		'ong' => array('host' => 'whois.nic.ong', 'free' => 'domain not found'),
		'onl' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'oracle' => array('host' => 'whois.nic.oracle', 'free' => 'no match'),
		'orange' => array('host' => 'whois.nic.orange', 'free' => 'no match'),
		'org' => array('host' => 'whois.pir.org', 'free' => 'not found'),
		'organic' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'origins' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'osaka' => array('host' => 'whois.nic.osaka', 'free' => 'no data found'),
		'ott' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ovh' => array('host' => 'whois.nic.ovh', 'free' => 'not found'),
		'page' => array('host' => 'whois.nic.google', 'free' => 'not found'),
		'panasonic' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'paris' => array('host' => 'whois.nic.paris', 'free' => 'not found'),
		'pars' => array('host' => 'whois.agitsys.net', 'free' => 'no object found'),
		'partners' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'parts' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'party' => array('host' => 'whois.nic.party', 'free' => 'no data found'),
		'pccw' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'pe' => array('host' => 'kero.yachay.pe', 'free' => 'no object found'),
		'pet' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'pf' => array('host' => 'whois.registry.pf', 'free' => 'domain unknown'),
		'phd' => array('host' => 'whois.nic.google', 'free' => 'domain not found'),
		'philips' => array('host' => 'whois.nic.philips', 'free' => 'no data found'),
		'phone' => array('host' => 'whois.nic.phone', 'free' => 'not found'),
		'photo' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'photography' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'photos' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'physio' => array('host' => 'whois.nic.physio', 'free' => 'no data found'),
		'pics' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'pictures' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'ping' => array('host' => 'whois.nic.ping', 'free' => 'no data found'),
		'pink' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'pioneer' => array('host' => 'whois.nic.pioneer', 'free' => 'this domain name has not been registered'),
		'pizza' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'agro.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'aid.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'atm.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'auto.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'biz.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'co.pl' => array('host' => 'whois.co.pl', 'free' => 'not found'),
		'com.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'edu.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'gmina.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'gsm.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'info.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'mail.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'media.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'miasta.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'mil.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'net.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'nom.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'org.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'pc.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'priv.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'realestate.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'rel.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'shop.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'sklep.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'sos.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'targi.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'tm.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'tourism.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'travel.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'turystyka.pl' => array('host' => 'whois.dns.pl', 'free' => 'no information available'),
		'place' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'play' => array('host' => 'whois.nic.google', 'free' => 'not found'),
		'playstation' => array('host' => 'whois.nic.playstation', 'free' => 'not found'),
		'plumbing' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'plus' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'pm' => array('host' => 'whois.nic.fr', 'free' => 'no entries found'),
		'pnc' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'poker' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'politie' => array('host' => 'whois.nic.politie', 'free' => 'status: free'),
		'porn' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'post' => array('host' => 'whois.dotpostregistry.net', 'free' => 'not found'),
		'pr' => array('host' => 'whois.nic.pr', 'free' => 'not found'),
		'pro' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'prod' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'productions' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'prof' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'progressive' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'promo' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'properties' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'property' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'ps' => array('host' => 'whois.pnina.ps', 'free' => 'no object found'),
		'pt' => array('host' => 'whois.dns.pt', 'free' => 'no match'),
		'com.pt' => array('host' => 'whois.dns.pt', 'free' => 'no match'),
		'edu.pt' => array('host' => 'whois.dns.pt', 'free' => 'no match'),
		'pub' => array('host' => 'whois.nic.pub', 'free' => 'domain not found.'),
		'pwc' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'qa' => array('host' => 'whois.registry.qa', 'free' => 'no data found'),
		'qpon' => array('host' => 'whois.nic.qpon', 'free' => 'no data found'),
		'quebec' => array('host' => 'whois.nic.quebec', 'free' => 'no match'),
		'quest' => array('host' => 'whois.nic.quest', 'free' => 'no data found'),
		'racing' => array('host' => 'whois.nic.racing', 'free' => 'no data found'),
		'radio' => array('host' => 'whois.nic.radio', 'free' => 'no match'),
		're' => array('host' => 'whois.nic.fr', 'free' => 'no entries found'),
		'realestate' => array('host' => 'whois.nic.realestate', 'free' => 'no match'),
		'recipes' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'red' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'redstone' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'redumbrella' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'rehab' => array('host' => 'whois.nic.rehab', 'free' => 'domain not found.'),
		'reise' => array('host' => 'whois.nic.reise', 'free' => 'not found'),
		'reisen' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'rentals' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'repair' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'report' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'republican' => array('host' => 'whois.nic.republican', 'free' => 'domain not found.'),
		'restaurant' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'review' => array('host' => 'whois.nic.review', 'free' => 'no data found'),
		'reviews' => array('host' => 'whois.nic.reviews', 'free' => 'domain not found.'),
		'rexroth' => array('host' => 'whois.nic.rexroth', 'free' => 'no match'),
		'rich' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'richardli' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ricoh' => array('host' => 'whois.nic.ricoh', 'free' => 'not found'),
		'rio' => array('host' => 'whois.gtlds.nic.br', 'free' => 'object does not exist'),
		'rip' => array('host' => 'whois.nic.rip', 'free' => 'domain not found.'),
		'ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'arts.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'com.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'firm.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'info.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'nom.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'nt.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'org.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'rec.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'store.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'tm.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'www.ro' => array('host' => 'whois.rotld.ro', 'free' => 'no entries found'),
		'rocks' => array('host' => 'whois.nic.rocks', 'free' => 'domain not found.'),
		'rodeo' => array('host' => 'whois.nic.rodeo', 'free' => 'this domain name has not been registered'),
		'rogers' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'room' => array('host' => 'whois.nic.room', 'free' => 'this domain name has not been registered'),
		'rs' => array('host' => 'whois.rnids.rs', 'free' => 'is not registered'),
		'co.rs' => array('host' => 'whois.rnids.rs', 'free' => '%error:103'),
		'edu.rs' => array('host' => 'whois.rnids.rs', 'free' => '%error:103'),
		'in.rs' => array('host' => 'whois.rnids.rs', 'free' => '%error:103'),
		'org.rs' => array('host' => 'whois.rnids.rs', 'free' => '%error:103'),
		'rsvp' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'ru' => array('host' => 'whois.ripn.net', 'free' => 'no entries found'),
		'com.ru' => array('host' => 'whois.ripn.net', 'free' => 'no entries found'),
		'edu.ru' => array('host' => 'whois.informika.ru', 'free' => 'is free.'),
		'msk.ru' => array('host' => 'whois.nic.ru', 'free' => 'no entries found'),
		'net.ru' => array('host' => 'whois.ripn.net', 'free' => 'no entries found'),
		'org.ru' => array('host' => 'whois.nic.ru', 'free' => 'no entries found'),
		'pp.ru' => array('host' => 'whois.nic.ru', 'free' => 'no entries found'),
		'spb.ru' => array('host' => 'whois.nic.ru', 'free' => 'no entries found'),
		'ruhr' => array('host' => 'whois.nic.ruhr', 'free' => 'no match'),
		'run' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'rw' => array('host' => 'whois.ricta.org.rw', 'free' => 'no object found'),
		'rwe' => array('host' => 'whois.nic.rwe', 'free' => 'no match'),
		'ryukyu' => array('host' => 'whois.nic.ryukyu', 'free' => 'domain not found'),
		'sa' => array('host' => 'whois.nic.net.sa', 'free' => 'no match for'),
		'sale' => array('host' => 'whois.nic.sale', 'free' => 'domain not found.'),
		'salon' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'samsclub' => array('host' => 'whois.nic.samsclub', 'free' => 'no match'),
		'samsung' => array('host' => 'whois.nic.samsung', 'free' => 'domain not found'),
		'sandvik' => array('host' => 'whois.nic.sandvik', 'free' => 'no data found'),
		'sandvikcoromant' => array('host' => 'whois.nic.sandvikcoromant', 'free' => 'no data found'),
		'sanofi' => array('host' => 'whois.nic.sanofi', 'free' => 'no match'),
		'sap' => array('host' => 'whois.nic.sap', 'free' => 'no match'),
		'sarl' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'saxo' => array('host' => 'whois.nic.saxo', 'free' => 'no data found'),
		'sb' => array('host' => 'whois.nic.net.sb', 'free' => 'no object found'),
		'sbi' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'sbs' => array('host' => 'whois.nic.sbs', 'free' => 'no match'),
		'sc' => array('host' => 'whois.afilias-grs.info', 'free' => 'not found'),
		'sca' => array('host' => 'whois.nic.sca', 'free' => 'no match for'),
		'scb' => array('host' => 'whois.nic.scb', 'free' => 'not found'),
		'schaeffler' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'schmidt' => array('host' => 'whois.nic.schmidt', 'free' => 'no data found'),
		'scholarships' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'school' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'schule' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'science' => array('host' => 'whois.nic.science', 'free' => 'no data found'),
		'scot' => array('host' => 'whois.nic.scot', 'free' => 'no matching objects found'),
		'se' => array('host' => 'whois.iis.se', 'free' => 'not found'),
		'search' => array('host' => 'whois.nic.google', 'free' => 'domain not found'),
		'seat' => array('host' => 'whois.nic.seat', 'free' => 'no match'),
		'secure' => array('host' => 'whois.nic.secure', 'free' => 'this domain name has not been registered'),
		'seek' => array('host' => 'whois.nic.seek', 'free' => 'no data found'),
		'select' => array('host' => 'whois.nic.select', 'free' => 'no data found'),
		'services' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'ses' => array('host' => 'whois.nic.ses', 'free' => 'no match'),
		'seven' => array('host' => 'whois.nic.seven', 'free' => 'no data found'),
		'sew' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'sex' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'sexy' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'sg' => array('host' => 'whois.sgnic.sg', 'free' => 'not found'),
		'com.sg' => array('host' => 'whois.sgnic.sg', 'free' => 'domain not found'),
		'edu.sg' => array('host' => 'whois.sgnic.sg', 'free' => 'domain not found'),
		'gov.sg' => array('host' => 'whois.sgnic.sg', 'free' => 'domain not found'),
		'net.sg' => array('host' => 'whois.sgnic.sg', 'free' => 'domain not found'),
		'org.sg' => array('host' => 'whois.sgnic.sg', 'free' => 'domain not found'),
		'sh' => array('host' => 'whois.nic.sh', 'free' => 'not found'),
		'shangrila' => array('host' => 'whois.nic.shangrila', 'free' => 'no match'),
		'sharp' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'shaw' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'shell' => array('host' => 'whois.nic.shell', 'free' => 'no match'),
		'shia' => array('host' => 'whois.agitsys.net', 'free' => 'no object found'),
		'shiksha' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'shoes' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'shop' => array('host' => 'whois.nic.shop', 'free' => 'domain not found'),
		'shopping' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'show' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'showtime' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'shriram' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'si' => array('host' => 'whois.arnes.si', 'free' => 'no entries found'),
		'sina' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'singles' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'sk' => array('host' => 'whois.sk-nic.sk', 'free' => 'not found'),
		'ski' => array('host' => 'whois.nic.ski', 'free' => 'not found'),
		'skin' => array('host' => 'whois.nic.skin', 'free' => 'no match'),
		'sky' => array('host' => 'whois.nic.sky', 'free' => 'no match'),
		'sl' => array('host' => 'whois.nic.sl', 'free' => 'no object found'),
		'sling' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'sm' => array('host' => 'whois.nic.sm', 'free' => 'no entries found'),
		'sn' => array('host' => 'whois.nic.sn', 'free' => 'not found'),
		'com.sn' => array('host' => 'whois.nic.sn', 'free' => 'not found'),
		'edu.sn' => array('host' => 'whois.nic.sn', 'free' => 'not found'),
		'gouv.sn' => array('host' => 'whois.nic.sn', 'free' => 'not found'),
		'org.sn' => array('host' => 'whois.nic.sn', 'free' => 'not found'),
		'sncf' => array('host' => 'whois.nic.sncf', 'free' => 'not found'),
		'so' => array('host' => 'whois.nic.so', 'free' => 'no object found'),
		'soccer' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'social' => array('host' => 'whois.nic.social', 'free' => 'domain not found.'),
		'softbank' => array('host' => 'whois.nic.softbank', 'free' => 'not found'),
		'software' => array('host' => 'whois.nic.software', 'free' => 'domain not found.'),
		'sohu' => array('host' => 'whois.gtld.knet.cn', 'free' => 'object does not exist'),
		'solar' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'solutions' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'sony' => array('host' => 'whois.nic.sony', 'free' => 'not found'),
		'soy' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'spa' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'sport' => array('host' => 'whois.nic.sport', 'free' => 'no matching objects found'),
		'srl' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'srt' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'st' => array('host' => 'whois.nic.st', 'free' => 'no entries found'),
		'stada' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'star' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'statebank' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'stockholm' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'su' => array('host' => 'whois.tcinet.ru', 'free' => 'no entries found'),
		'ss' => array('host' => 'whois.nic.ss', 'free' => 'no object found'),
		'biz.ss' => array('host' => 'whois.nic.ss', 'free' => 'no object found'),
		'com.ss' => array('host' => 'whois.nic.ss', 'free' => 'no object found'),
		'me.ss' => array('host' => 'whois.nic.ss', 'free' => 'no object found'),
		'net.ss' => array('host' => 'whois.nic.ss', 'free' => 'no object found'),
		'studio' => array('host' => 'whois.nic.studio', 'free' => 'domain not found.'),
		'study' => array('host' => 'whois.nic.study', 'free' => 'no data found'),
		'stream' => array('host' => 'whois.nic.stream', 'free' => 'no data found'),
		'style' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'su' => array('host' => 'whois.ripn.net', 'free' => 'no entries found'),
		'sochi.su' => array('host' => 'whois.nic.ru', 'free' => 'no entries found'),
		'sucks' => array('host' => 'whois.nic.sucks', 'free' => 'no data found'),
		'supplies' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'supply' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'support' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'surf' => array('host' => 'whois.nic.surf', 'free' => 'this domain name has not been registered'),
		'surgery' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'swatch' => array('host' => 'whois.nic.swatch', 'free' => 'no match'),
		'swiss' => array('host' => 'whois.nic.swiss', 'free' => 'no match'),
		'sx' => array('host' => 'whois.sx', 'free' => 'no match for'),
		'sy' => array('host' => 'whois.tld.sy', 'free' => 'no object found'),
		'sydney' => array('host' => 'whois.nic.sydney', 'free' => 'no data found'),
		'systems' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'tab' => array('host' => 'whois.nic.tab', 'free' => 'no data found'),
		'talk' => array('host' => 'whois.nic.talk', 'free' => 'this domain name has not been registered'),
		'taipei' => array('host' => 'whois.nic.taipei', 'free' => 'no data found'),
		'tatamotors' => array('host' => 'whois.nic.tatamotors', 'free' => 'no match'),
		'tatar' => array('host' => 'whois.nic.tatar', 'free' => 'object does not exist'),
		'tattoo' => array('host' => 'whois.uniregistry.net', 'free' => 'is available for registration'),
		'tax' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'taxi' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'tc' => array('host' => 'whois.nic.tc', 'free' => 'no object found'),
		'tci' => array('host' => 'whois.agitsys.net', 'free' => 'no object found'),
		'td' => array('host' => 'whois.nic.td', 'free' => 'no object found'),
		'tdk' => array('host' => 'whois.nic.tdk', 'free' => 'no data found'),
		'team' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'technology' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'tel' => array('host' => 'whois.nic.tel', 'free' => 'no data found'),
		'temasek' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'tennis' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'teva' => array('host' => 'whois.nic.teva', 'free' => 'no data found'),
		'tf' => array('host' => 'whois.nic.tf', 'free' => 'no entries found'),
		'tg' => array('host' => 'whois.nic.tg', 'free' => 'no object found'),
		'th' => array('host' => 'whois.thnic.co.th', 'free' => 'no match for'),
		'ac.th' => array('host' => 'whois.thnic.net', 'free' => 'no match for'),
		'co.th' => array('host' => 'whois.thnic.net', 'free' => 'no match for'),
		'go.th' => array('host' => 'whois.thnic.net', 'free' => 'no match for'),
		'in.th' => array('host' => 'whois.thnic.net', 'free' => 'no match for'),
		'mi.th' => array('host' => 'whois.thnic.net', 'free' => 'no match for'),
		'net.th' => array('host' => 'whois.thnic.net', 'free' => 'no match for'),
		'or.th' => array('host' => 'whois.thnic.net', 'free' => 'no match for'),
		'thd' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'theater' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'tiaa' => array('host' => 'whois.nic.tiaa', 'free' => 'no match'),
		'tienda' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'tiffany' => array('host' => 'whois.nic.tiffany', 'free' => 'no match'),
		'tiffay' => array('host' => 'whois.nic.tiffany', 'free' => 'no match'),
		'tips' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'tires' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'tirol' => array('host' => 'whois.nic.tirol', 'free' => 'no information was found'),
		'tk' => array('host' => 'whois.freenom.com', 'free' => 'domain name not known'),
		'tl' => array('host' => 'whois.nic.tl', 'free' => 'no object found'),
		'tm' => array('host' => 'whois.nic.tm', 'free' => 'is available'),
		'tn' => array('host' => 'whois.ati.tn', 'free' => 'no object found!'),
		'to' => array('host' => 'whois.tonic.to', 'free' => 'no match for'),
		'today' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'tokyo' => array('host' => 'whois.nic.tokyo', 'free' => 'not found'),
		'tools' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'top' => array('host' => 'whois.nic.top', 'free' => 'object does not exist'),
		'toray' => array('host' => 'whois.nic.toray', 'free' => 'not found'),
		'toshiba' => array('host' => 'whois.nic.toshiba', 'free' => 'not found'),
		'total' => array('host' => 'whois.nic.total', 'free' => 'not found'),
		'tours' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'town' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'toyota' => array('host' => 'whois.nic.toyota', 'free' => 'not found'),
		'toys' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'av.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'bbs.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'bel.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'biz.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'com.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'dr.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'edu.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'gen.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'gov.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'info.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'k12.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'name.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'net.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'org.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'pol.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'tel.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'tsk.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'tv.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'web.tr' => array('host' => 'whois.trabis.gov.tr', 'free' => 'no match found'),
		'trade' => array('host' => 'whois.nic.trade', 'free' => 'no data found'),
		'trading' => array('host' => 'whois.nic.trading', 'free' => 'no match'),
		'training' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'travel' => array('host' => 'whois.nic.travel', 'free' => 'no data found'),
		'travelchannel' => array('host' => 'whois.nic.travelchannel', 'free' => 'no match'),
		'travelers' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'travelersinsurance' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'trust' => array('host' => 'whois.nic.trust', 'free' => 'no data found'),
		'trv' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'tube' => array('host' => 'whois.nic.tube', 'free' => 'no data found'),
		'tv' => array('host' => 'tvwhois.verisign-grs.com', 'free' => 'no match for'),
		'tvs' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'tw' => array('host' => 'whois.twnic.net', 'free' => 'no found'),
		'com.tw' => array('host' => 'whois.twnic.net', 'free' => 'no found'),
		'net.tw' => array('host' => 'whois.twnic.net', 'free' => 'no found'),
		'org.tw' => array('host' => 'whois.twnic.net', 'free' => 'no found'),
		'tz' => array('host' => 'whois.tznic.or.tz', 'free' => '% no entries found.'),
		'ua' => array('host' => 'whois.ua', 'free' => 'no entries found'),
		'biz.ua' => array('host' => 'whois.biz.ua', 'free' => 'no entries found'),
		'co.ua' => array('host' => 'whois.co.ua', 'free' => 'no entries found'),
		'com.ua' => array('host' => 'whois.com.ua', 'free' => 'no entries found for'),
		'dn.ua' => array('host' => 'whois.dn.ua', 'free' => 'no entries found'),
		'in.ua' => array('host' => 'whois.in.ua', 'free' => 'domain name does not exist'),
		'kh.ua' => array('host' => 'whois.net.ua', 'free' => 'no entries found'),
		'kiev.ua' => array('host' => 'whois.kiev.ua', 'free' => 'no entries found'),
		'lg.ua' => array('host' => 'whois.net.ua', 'free' => 'no entries found'),
		'lviv.ua' => array('host' => 'whois.lviv.ua', 'free' => 'no object found'),
		'net.ua' => array('host' => 'whois.net.ua', 'free' => 'no entries found'),
		'pp.ua' => array('host' => 'whois.pp.ua', 'free' => 'no entries found'),
		'ubank' => array('host' => 'whois.nic.ubank', 'free' => 'no match'),
		'ubs' => array('host' => 'whois.nic.ubs', 'free' => 'no match'),
		'uconnect' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ug' => array('host' => 'whois.co.ug', 'free' => 'no entries found'),
		'uk' => array('host' => 'whois.nic.uk', 'free' => 'no match'),
		'ac.uk' => array('host' => 'whois.ja.net', 'free' => 'no such domain'),
		'co.uk' => array('host' => 'whois.nic.uk', 'free' => 'no match'),
		'gov.uk' => array('host' => 'whois.ja.net', 'free' => 'no such domain'),
		'ltd.uk' => array('host' => 'whois.nic.uk', 'free' => 'no match'),
		'me.uk' => array('host' => 'whois.nic.uk', 'free' => 'no match'),
		'net.uk' => array('host' => 'whois.nic.uk', 'free' => 'no match'),
		'org.uk' => array('host' => 'whois.nic.uk', 'free' => 'no match'),
		'plc.uk' => array('host' => 'whois.nic.uk', 'free' => 'no match'),
		'university' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'uno' => array('host' => 'whois.nic.uno', 'free' => 'no data found'),
		'uol' => array('host' => 'whois.gtlds.nic.br', 'free' => 'object does not exist'),
		'ups' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'us' => array('host' => 'whois.nic.us', 'free' => 'no data found'),
		'fed.us' => array('host' => 'whois.nic.gov', 'free' => 'no match for'),
		'uy' => array('host' => 'whois.nic.org.uy', 'free' => 'no match for'),
		'uz' => array('host' => 'whois.cctld.uz', 'free' => 'not found'),
		'vacations' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'vana' => array('host' => 'whois.nic.vana', 'free' => 'is available for registration'),
		'vanguard' => array('host' => 'whois.nic.vanguard', 'free' => 'no match'),
		'vc' => array('host' => 'whois2.afilias-grs.net', 'free' => 'not found'),
		'vegas' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'ventures' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'verisign' => array('host' => 'whois.nic.verisign', 'free' => 'no match'),
		'versicherung' => array('host' => 'whois.nic.versicherung', 'free' => 'object does not exist'),
		'vet' => array('host' => 'whois.nic.vet', 'free' => 'domain not found.'),
		'viajes' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'video' => array('host' => 'whois.nic.video', 'free' => 'domain not found.'),
		'vig' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'viking' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'villas' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'vin' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'vip' => array('host' => 'whois.nic.vip', 'free' => 'this domain name has not been registered'),
		'virgin' => array('host' => 'whois.nic.virgin', 'free' => 'no data found'),
		'visa' => array('host' => 'whois.nic.visa', 'free' => 'no match'),
		'vision' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'vlaanderen' => array('host' => 'whois.nic.vlaanderen', 'free' => 'domain not found.'),
		'vn' => array('func' => 'vn'),
		'com.vn' => array('func' => 'vn'),
		'net.vn' => array('func' => 'vn'),
		'org.vn' => array('func' => 'vn'),
		'edu.vn' => array('func' => 'vn'),
		'biz.vn' => array('func' => 'vn'),
		'name.vn' => array('func' => 'vn'),
		'int.vn' => array('func' => 'vn'),
		'gov.vn' => array('func' => 'vn'),
		'info.vn' => array('func' => 'vn'),
		'ac.vn' => array('func' => 'vn'),
		'health.vn' => array('func' => 'vn'),
		'pro.vn' => array('func' => 'vn'),
		'idn.vn' => array('func' => 'vn'),
		'angiang.vn' => array('func' => 'vn'),
		'bacgiang.vn' => array('func' => 'vn'),
		'backan.vn' => array('func' => 'vn'),
		'baclieu.vn' => array('func' => 'vn'),
		'bacninh.vn' => array('func' => 'vn'),
		'baria-vungtau.vn' => array('func' => 'vn'),
		'bentre.vn' => array('func' => 'vn'),
		'binhdinh.vn' => array('func' => 'vn'),
		'binhduong.vn' => array('func' => 'vn'),
		'binhphuoc.vn' => array('func' => 'vn'),
		'binhthuan.vn' => array('func' => 'vn'),
		'camau.vn' => array('func' => 'vn'),
		'cantho.vn' => array('func' => 'vn'),
		'caobang.vn' => array('func' => 'vn'),
		'daklac.vn' => array('func' => 'vn'),
		'daknong.vn' => array('func' => 'vn'),
		'danang.vn' => array('func' => 'vn'),
		'dienbien.vn' => array('func' => 'vn'),
		'dongnai.vn' => array('func' => 'vn'),
		'dongthap.vn' => array('func' => 'vn'),
		'gialai.vn' => array('func' => 'vn'),
		'kontum.vn' => array('func' => 'vn'),
		'laichau.vn' => array('func' => 'vn'),
		'lamdong.vn' => array('func' => 'vn'),
		'langson.vn' => array('func' => 'vn'),
		'laocai.vn' => array('func' => 'vn'),
		'longan.vn' => array('func' => 'vn'),
		'namdinh.vn' => array('func' => 'vn'),
		'nghean.vn' => array('func' => 'vn'),
		'ninhbinh.vn' => array('func' => 'vn'),
		'ninhthuan.vn' => array('func' => 'vn'),
		'hagiang.vn' => array('func' => 'vn'),
		'haiduong.vn' => array('func' => 'vn'),
		'haiphong.vn' => array('func' => 'vn'),
		'hanam.vn' => array('func' => 'vn'),
		'hanoi.vn' => array('func' => 'vn'),
		'hatinh.vn' => array('func' => 'vn'),
		'haugiang.vn' => array('func' => 'vn'),
		'hoabinh.vn' => array('func' => 'vn'),
		'hungyen.vn' => array('func' => 'vn'),
		'khanhhoa.vn' => array('func' => 'vn'),
		'kiengiang.vn' => array('func' => 'vn'),
		'phutho.vn' => array('func' => 'vn'),
		'phuyen.vn' => array('func' => 'vn'),
		'quangbinh.vn' => array('func' => 'vn'),
		'quangnam.vn' => array('func' => 'vn'),
		'quangngai.vn' => array('func' => 'vn'),
		'quangninh.vn' => array('func' => 'vn'),
		'quangtri.vn' => array('func' => 'vn'),
		'soctrang.vn' => array('func' => 'vn'),
		'sonla.vn' => array('func' => 'vn'),
		'tayninh.vn' => array('func' => 'vn'),
		'thaibinh.vn' => array('func' => 'vn'),
		'thainguyen.vn' => array('func' => 'vn'),
		'thanhhoa.vn' => array('func' => 'vn'),
		'thanhphohochiminh.vn' => array('func' => 'vn'),
		'thuathienhue.vn' => array('func' => 'vn'),
		'tiengiang.vn' => array('func' => 'vn'),
		'travinh.vn' => array('func' => 'vn'),
		'tuyenquang.vn' => array('func' => 'vn'),
		'vinhlong.vn' => array('func' => 'vn'),
		'vinhphuc.vn' => array('func' => 'vn'),
		'yenbai.vn' => array('func' => 'vn'),
		'vodka' => array('host' => 'whois.nic.vodka', 'free' => 'this domain name has not been registered'),
		'volkswagen' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'volvo' => array('host' => 'whois.nic.volvo', 'free' => 'no match'),
		'vote' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'voting' => array('host' => 'whois.nic.voting', 'free' => 'no data found'),
		'voto' => array('host' => 'whois.afilias.net', 'free' => 'not found'),
		'voyage' => array('host' => 'whois.donuts.co', 'free' => 'domain not found'),
		'vu' => array('host' => 'whois.dnrs.vu', 'free' => 'no data found'),
		'wales' => array('host' => 'whois.nic.wales', 'free' => 'this domain name has not been registered'),
		'walmart' => array('host' => 'whois.nic.walmart', 'free' => 'no match'),
		'walter' => array('host' => 'whois.nic.walter', 'free' => 'no data found'),
		'wang' => array('host' => 'whois.gtld.knet.cn', 'free' => 'object does not exist'),
		'watch' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'watches' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'webcam' => array('host' => 'whois.nic.webcam', 'free' => 'no data found'),
		'weber' => array('host' => 'whois.nic.weber', 'free' => 'no match'),
		'wed' => array('host' => 'whois.nic.wed', 'free' => 'this domain name has not been registered'),
		'wedding' => array('host' => 'whois.nic.wedding', 'free' => 'this domain name has not been registered'),
		'weibo' => array('host' => 'whois.nic.weibo', 'free' => 'not found'),
		'wf' => array('host' => 'whois.nic.fr', 'free' => 'no entries found'),
		'whoswho' => array('host' => 'whois.nic.whoswho', 'free' => 'no data found'),
		'wien' => array('host' => 'whois.nic.wien', 'free' => 'available'),
		'win' => array('host' => 'whois.nic.win', 'free' => 'no data found'),
		'wine' => array('host' => 'whois.donuts.co', 'free' => 'not found'),
		'wolterskluwer' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'woodside' => array('host' => 'whois.nic.woodside', 'free' => 'no data found'),
		'work' => array('host' => 'whois.nic.work', 'free' => 'this domain name has not been registered'),
		'works' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'world' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'ws' => array('host' => 'whois.website.ws', 'free' => 'object does not exist'),
		'wtc' => array('host' => 'whois.nic.wtc', 'free' => 'no data found'),
		'wtf' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'xerox' => array('host' => 'whois.nic.xerox', 'free' => 'no match'),
		'xfinity' => array('host' => 'whois.nic.xfinity', 'free' => 'this domain name has not been registered'),
		'xin' => array('host' => 'whois.nic.xin', 'free' => 'not found'),
		'xxx' => array('host' => 'whois.nic.xxx', 'free' => 'not found'),
		'yachts' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'yodobashi' => array('host' => 'whois.nic.gmo', 'free' => 'not found'),
		'yoga' => array('host' => 'whois.nic.yoga', 'free' => 'this domain name has not been registered'),
		'yokohama' => array('host' => 'whois.nic.yokohama', 'free' => 'domain not found'),
		'you' => array('host' => 'whois.nic.you', 'free' => 'this domain name has not been registered'),
		'youtube' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'yt' => array('host' => 'whois.nic.yt', 'free' => 'not found'),
		'co.za' => array('host' => 'co-whois.registry.net.za', 'free' => 'available'),
		'net.za' => array('host' => 'net-whois.registry.net.za', 'free' => 'available'),
		'org.za' => array('host' => 'org-whois.registry.net.za', 'free' => 'available'),
		'web.za' => array('host' => 'web-whois.registry.net.za', 'free' => 'available'),
		'zara' => array('host' => 'whois.afilias-srs.net', 'free' => 'not found'),
		'zip' => array('host' => 'whois.nic.google', 'free' => 'domain not found.'),
		'zm' => array('host' => 'whois.nic.zm', 'free' => 'domain status: no object found'),
		'zone' => array('host' => 'whois.donuts.co', 'free' => 'domain not found.'),
		'zuerich' => array('host' => 'whois.nic.zuerich', 'free' => 'domain not found'),
		// Cyrillic TLDs
		'дети' => array('host' => 'whois.nic.xn--d1acj3b', 'free' => 'object does not exist'), // xn--d1acj3b
		'сайт' => array('host' => 'whois.nic.xn--80aswg', 'free' => 'object does not exist'), // xn--80aswg
		'москва' => array('host' => 'whois.nic.xn--80adxhks', 'free' => 'domain not found.'), // xn--80adxhks
		'онлайн' => array('host' => 'whois.nic.xn--80asehdb', 'free' => 'object does not exist'), // xn--80asehdb
		'орг' => array('host' => 'whois.publicinterestregistry.net', 'free' => 'not found'), // xn--c1avg
		'рф' => array('host' => 'whois.tcinet.ru', 'free' => 'no entries found'), // xn--p1ai
		'рус' => array('host' => 'whois.nic.xn--p1acf', 'free' => 'no object found'), // xn--p1acf
		// CentralNic TLDs
		'art' => array('host' => 'whois.nic.art', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'baby' => array('host' => 'whois.nic.baby', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'bar' => array('host' => 'whois.nic.bar', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'basketball' => array('host' => 'whois.nic.basketball', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'best' => array('host' => 'whois.nic.best', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'bh' => array('host' => 'whois.nic.bh', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'blog' => array('host' => 'whois.nic.blog', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'bond' => array('host' => 'whois.nic.bond', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'cam' => array('host' => 'whois.nic.cam', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'ceo' => array('host' => 'whois.nic.ceo', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'college' => array('host' => 'whois.nic.college', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'cyou' => array('host' => 'whois.nic.cyou', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'desi' => array('host' => 'whois.nic.desi', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'design' => array('host' => 'whois.nic.design', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'fans' => array('host' => 'whois.nic.fans', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'feedback' => array('host' => 'whois.nic.feedback', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'fm' => array('host' => 'whois.nic.fm', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'fo' => array('host' => 'whois.nic.fo', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'forum' => array('host' => 'whois.nic.forum', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'frl' => array('host' => 'whois.nic.frl', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'fun' => array('host' => 'whois.nic.fun', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'gay' => array('host' => 'whois.nic.gay', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'gd' => array('host' => 'whois.nic.gd', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'gent' => array('host' => 'whois.nic.gent', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'hair' => array('host' => 'whois.nic.hair', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'homes' => array('host' => 'whois.nic.homes', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'host' => array('host' => 'whois.nic.host', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'icu' => array('host' => 'whois.nic.icu', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'ink' => array('host' => 'whois.nic.ink', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'kred' => array('host' => 'whois.nic.kred', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'love' => array('host' => 'whois.nic.love', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'monster' => array('host' => 'whois.nic.monster', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'observer' => array('host' => 'whois.nic.observer', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'online' => array('host' => 'whois.nic.online', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'ooo' => array('host' => 'whois.nic.ooo', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'pid' => array('host' => 'whois.nic.pid', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'press' => array('host' => 'whois.nic.press', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'protection' => array('host' => 'whois.nic.protection', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'pw' => array('host' => 'whois.nic.pw', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'realty' => array('host' => 'whois.nic.realty', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'reit' => array('host' => 'whois.nic.reit', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'rent' => array('host' => 'whois.nic.rent', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'rest' => array('host' => 'whois.nic.rest', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'rugby' => array('host' => 'whois.nic.rugby', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'saarland' => array('host' => 'whois.nic.saarland', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'security' => array('host' => 'whois.nic.security', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'site' => array('host' => 'whois.nic.site', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'space' => array('host' => 'whois.nic.space', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'storage' => array('host' => 'whois.nic.storage', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'store' => array('host' => 'whois.nic.store', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'tech' => array('host' => 'whois.nic.tech', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'theatre' => array('host' => 'whois.nic.theatre', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'tickets' => array('host' => 'whois.nic.tickets', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'vg' => array('host' => 'whois.nic.vg', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'website' => array('host' => 'whois.nic.website', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'wiki' => array('host' => 'whois.nic.wiki', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
		'xyz' => array('host' => 'whois.nic.xyz', 'free' => 'domain not found', 'limit_group' => 'centralnic'),
	);

	/**
	 * @var array Invalid strings.
	 */
	private static $status_invalid = array(
		'% invalid query',
		'%invalid pattern',
		'>>> object ".+" not found',
		'domain name contains invalid characters',
		'error - invalid request',
		'error code: 10112',
		'error for "',
		'error in xml structure',
		'error: invalid query',
		'incorrect characters in domain name',
		'incorrect domain name',
		'incorrect input, please try again',
		'invalid \..+ domain name',
		'invalid domain name',
		'invalid parameter:',
		'invalid query:',
		'invalid request name',
		'invalid request.',
		'invalid request:',
		'invalid_query_error',
		'malformed domain name',
		'malformed request.',
		'no information was found matching that query',
		'no registrar found.',
		'not a valid domain search pattern',
		'not valid domain name',
		'status: invalid',
		'status: not allowed',
		'strange request:',
		'syntax error or wrong char(s) in query',
		'syntax error.',
		'the queried object does not exist: illegal question',
		'the query type is incorrect',
		'the server was unable to process your request for',
		'we do not understand the query you made',
		'whois query rejected',
	);

	/**
	 * @var array Access control limit strings.
	 */
	private static $status_limit = array(
		'access control limit exceeded',
		'has been exceeded',
		'maximum number of requests per second exceeded',
		'maximum query rate reached',
		'number of allowed queries exceeded',
		'please go away for',
		'please try again',
		'query limit exceeded',
		'query rate is now high',
		'quota exceeded',
		'rate limit exceeded',
		'service currently unavailable',
		'too many requests',
		'try again later',
		'whois limit exceeded',
		'you exceeded the maximum allowable number of whois lookups',
		'you reach a limit of requests for your ip address',
		'your access is too fast',
		'your request could not be performed',
	);

	/**
	 * @var array Web whois links.
	 */
	private static $webwhois = array(
		'bd' => 'https://bdia.btcl.com.bd',
		'ec' => 'https://nic.ec/domain-registration/domain-whois-lookup.php',
		'es' => 'https://www.nic.es/sgnd/dominio/publicBuscarDominios.action?tDominio.nombreDominio=[domain]&flag=activado',
		'gr' => 'https://grweb.ics.forth.gr/public/whois',
		'lat' => 'https://whois.nic.lat',
		'mx' => 'https://whois.mx',
		'my' => 'https://mynic.my/whois',
	);

	/**
	 * Get whois server information for a tld.
	 * 
	 * @param string $tld 
	 * @return array Host and free status string.
	 */
	public static function get_whoisserver( $tld ) {
		if ( ! isset( self::$whoisservers[ $tld ] ) )
			return false;
		return self::$whoisservers[ $tld ];
	}

	/**
	 * Get subset of whois server list.
	 * 
	 * @param int $offset 
	 * @param int|null $length 
	 * @return array Whois server list array.
	 */
	public static function get_whoisservers( $offset = 0, $length = NULL ) {
		return array_slice( self::$whoisservers, $offset, $length );
	}

	/**
	 * Get all invalid strings.
	 * 
	 * @return string Concatenated string list.
	 */
	public static function get_pattern_invalid() {
		return implode( '|', self::$status_invalid );
	}

	/**
	 * Get all limit strings.
	 * 
	 * @return string Concatenated string list.
	 */
	public static function get_pattern_limit() {
		return implode( '|', self::$status_limit );
	}

	/**
	 * Get web whois link for a tld.
	 * 
	 * @param string $tld 
	 * @return string Web whois link.
	 */
	public static function get_webwhois( $tld ) {
		$dot_position = strrpos( $tld, '.' );
		if ( $dot_position !== false ) {
			// extract tld from sld
			$tld = substr( $tld, $dot_position + 1 );
		}
		if ( ! isset( self::$webwhois[ $tld ] ) )
			return false;
		return self::$webwhois[ $tld ];
	}

}
